% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{update_cumulative_edgelist}
\alias{update_cumulative_edgelist}
\title{Update a Cumulative Edgelist of the Specified Network}
\usage{
update_cumulative_edgelist(dat, network, truncate = Inf)
}
\arguments{
\item{dat}{a Master list object of network models}

\item{network}{the index of the network whose cumulative edgelist will be
updated}

\item{truncate}{after how many steps an edge that is no longer active should
be removed from the cumulative edgelist (default = Inf)}
}
\value{
an updated Master list object of network models
}
\description{
Update a Cumulative Edgelist of the Specified Network
}
\section{Truncation}{

To avoid storing a cumulative edgelist to long, the `truncate`
parameter defines a number of steps after which an edge that is no longer
active is truncated out of the cummulative edgelist. When `truncate == Inf`
(default), no edge is ever removed. When `truncate == 0`, only the active
edges are kept. You may want this behavior to keep track of the active edges
start step.
}

