% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.icm}
\alias{merge.icm}
\title{Merge Data across Stochastic Individual Contact Model Simulations}
\usage{
\method{merge}{icm}(x, y, ...)
}
\arguments{
\item{x}{An \code{EpiModel} object of class \code{\link{icm}}.}

\item{y}{Another \code{EpiModel} object of class \code{\link{icm}}, with the
identical model parameterization as \code{x}.}

\item{...}{Additional merge arguments (not used).}
}
\value{
An \code{EpiModel} object of class \code{\link{icm}} containing the
data from both \code{x} and \code{y}.
}
\description{
Merges epidemiological data from two independent simulations of
stochastic individual contact models from \code{\link{icm}}.
}
\details{
This merge function combines the results of two independent simulations of
\code{\link{icm}} class models, simulated under separate function calls. The
model parameterization between the two calls must be exactly the same, except
for the number of simulations in each call. This allows for manual
parallelization of model simulations.

This merge function does not work the same as the default merge, which allows
for a combined object where the structure differs between the input elements.
Instead, the function checks that objects are identical in model
parameterization in every respect (except number of simulations) and binds
the results.
}
\examples{
param <- param.icm(inf.prob = 0.2, act.rate = 0.8)
init <- init.icm(s.num = 1000, i.num = 100)
control <- control.icm(type = "SI", nsteps = 10,
                       nsims = 3, verbose = FALSE)
x <- icm(param, init, control)

control <- control.icm(type = "SI", nsteps = 10,
                       nsims = 1, verbose = FALSE)
y <- icm(param, init, control)

z <- merge(x, y)

# Examine separate and merged data
as.data.frame(x)
as.data.frame(y)
as.data.frame(z)

}
\keyword{extract}
