% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{get_cumulative_degree}
\alias{get_cumulative_degree}
\title{Return the Cumulative Degree of a Set of Index Nodes}
\usage{
get_cumulative_degree(
  dat,
  index_posit_ids,
  networks = NULL,
  truncate = Inf,
  only.active.nodes = FALSE
)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}

\item{index_posit_ids}{The positional IDs of the indexes of interest.}

\item{networks}{Numerical indexes of the networks to extract the partnerships from. (May be > 1
for models with multi-layer networks.) If \code{NULL}, extract from all networks.}

\item{truncate}{After how many time steps a partnership that is no longer
active should be removed from the output.}

\item{only.active.nodes}{If \code{TRUE}, then inactive (e.g., deceased) partners will be removed from
the output.}
}
\value{
A \code{data.frame} with 2 columns:
\itemize{
\item \code{index_pid}: the positional ID (see \code{get_posit_ids}) of the
indexes.
\item \code{degree}: the cumulative degree of the index.
}
}
\description{
Return the Cumulative Degree of a Set of Index Nodes
}
\section{Cumulative Degree}{

The cumulative degree of a node is the number of edges connected to this
node at during the time window. The time window is by default all the steps
stored in the \code{cumulative_edgelist} or set by the \code{truncate} parameter.
}

