% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{bootstrapped_dist_fit}
\alias{bootstrapped_dist_fit}
\title{Fit a Subsampled Bootstrap to Integer Values and Summarise Distribution
Parameters}
\usage{
bootstrapped_dist_fit(
  values,
  dist = "lognormal",
  samples = 2000,
  bootstraps = 10,
  bootstrap_samples = 250,
  max_value,
  verbose = FALSE
)
}
\arguments{
\item{values}{Integer vector of values.}

\item{dist}{Character string, which distribution to fit. Defaults to
lognormal (\code{"lognormal"}) but gamma (\code{"gamma"}) is also supported.}

\item{samples}{Numeric, number of samples to take overall from the
bootstrapped posteriors.}

\item{bootstraps}{Numeric, defaults to 1. The number of bootstrap samples
(with replacement) of the delay distribution to take.}

\item{bootstrap_samples}{Numeric, defaults to 100. The number of samples to
take in each bootstrap. When the sample size of the supplied delay
distribution is less than 100 this is used instead.}

\item{max_value}{Numeric, defaults to  the maximum value in the observed
data. Maximum delay to  allow (added to output but does impact fitting).}

\item{verbose}{Logical, defaults to \code{FALSE}. Should progress messages be
printed.}
}
\value{
A \code{dist_spec} object summarising the bootstrapped distribution
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Fits an integer adjusted distribution to a subsampled bootstrap of data and
then integrates the posterior samples into a single set of summary
statistics. Can be used to generate a robust reporting delay that accounts
for the fact the underlying delay likely varies over time or that the size
of the available reporting delay sample may not be representative of the
current case load.
}
\examples{
\donttest{
# lognormal
delays <- rlnorm(500, log(5), 1)
out <- bootstrapped_dist_fit(delays,
  samples = 1000, bootstraps = 10,
  dist = "lognormal"
)
out
}
}
\author{
Sam Abbott
}
