% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EunomiaData.R
\name{loadDataFiles}
\alias{loadDataFiles}
\title{Load data files into a database(sqlite or duckdb)}
\usage{
loadDataFiles(
  dataPath,
  dbPath,
  inputFormat = "csv",
  cdmVersion = "5.3",
  cdmDatabaseSchema = "main",
  dbms = "sqlite",
  verbose = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{dataPath}{The path to the directory containing CDM source files (csv or parquet)}

\item{dbPath}{The path to the .sqlite or .duckdb file that will be created}

\item{inputFormat}{The input format of the files to load.  Supported formats include csv, parquet.}

\item{cdmVersion}{The CDM version to create in the resulting database. Supported versions are 5.3 and 5.4}

\item{cdmDatabaseSchema}{The schema in which to create the CDM tables. Default is main.}

\item{dbms}{The file-based database system to use: 'sqlite' (default) or 'duckdb'}

\item{verbose}{Provide additional logging details during execution.}

\item{overwrite}{Remove and replace an existing data set.}
}
\value{
No return value, loads data into database file.
}
\description{
Load data from csv or parquet files into a database file (sqlite or duckdb).
}
