% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortMethod.R
\name{plotPreparedPs}
\alias{plotPreparedPs}
\title{Plot the propensity score distribution}
\usage{
plotPreparedPs(
  preparedPsPlots,
  labels,
  treatmentLabel = "Target",
  comparatorLabel = "Comparator",
  fileName = NULL
)
}
\arguments{
\item{preparedPsPlots}{list of prepared propensity score data as created by the \code{\link[=preparePsPlot]{preparePsPlot()}}
function.}

\item{labels}{A vector containing the labels for the various sources.}

\item{treatmentLabel}{A label to us for the treated cohort.}

\item{comparatorLabel}{A label to us for the comparator cohort.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'.
See the function \link[ggplot2:ggsave]{ggplot2::ggsave} for supported file formats.}
}
\value{
A ggplot object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file in a different format.
}
\description{
Plot the propensity score distribution
}
\examples{
# Simulate some data for this example:
treatment <- rep(0:1, each = 100)
propensityScore <- c(rnorm(100, mean = 0.4, sd = 0.25), rnorm(100, mean = 0.6, sd = 0.25))
data <- data.frame(treatment = treatment, propensityScore = propensityScore)
data <- data[data$propensityScore > 0 & data$propensityScore < 1, ]
preparedPlot <- preparePsPlot(data)

# Just reusing the same data three times for demonstration purposes:
preparedPsPlots <- list(preparedPlot, preparedPlot, preparedPlot)
labels <- c("Data site A", "Data site B", "Data site C")

plotPreparedPs(preparedPsPlots, labels)

}
\seealso{
\link{preparePsPlot}
}
