/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;

public class EmpiricalModelLikelihood
extends AbstractModelLikelihood {
    private final Likelihood likelihood;
    private final Parameter parameter;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private double logLikelihood;
    private double storedLogLikelihood;

    public EmpiricalModelLikelihood(String string, EmpiricalDataModel empiricalDataModel) {
        super(string);
        this.setId(string);
        this.likelihood = empiricalDataModel.getLikelihood();
        this.parameter = empiricalDataModel.getCompoundParameter();
        this.addVariable((Variable)this.parameter);
        this.likelihoodKnown = false;
    }

    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new RuntimeException("Unknown model");
    }

    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.parameter) {
            throw new RuntimeException("Unknown variable");
        }
        this.likelihoodKnown = false;
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.likelihood.getLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
    }
}

