% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eviews_wfcreate.R
\name{eviews_wfcreate}
\alias{eviews_wfcreate}
\title{Create an `EViews` workfile from R}
\usage{
eviews_wfcreate(source_description="",wf="",page="",prompt=F,frequency="",
subperiod_opts="",start_date="",end_date="",num_cross_sections=NA,num_observations=NA,
save_path="")
}
\arguments{
\item{source_description}{Description of the file from which the data is to be imported. The specification of the description is usually just the path and file name of the file.}

\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{page}{Object or a character string representing the name of a workfile page to be created}

\item{prompt}{Logical, whether to force the dialog to appear from within an `EViews` program}

\item{frequency}{Object or a character string representing the frequency of a workfile page to be created. Only letters accepted by EViews are allowed. For example \code{u} for undated, \code{a} for annual, \code{m} for monthly and so on.}

\item{subperiod_opts}{Optional integer value. Include \code{subperiod_opts} to define subperiod options for \code{frequency} argument.}

\item{start_date}{Object or a character string representing the \code{start date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{end_date}{Object or a character string representing the \code{end date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{num_cross_sections}{Optional integer value. Include \code{num_cross_sections} in order to create an `EViews` balanced panel page using integer identifiers for each of the cross-sections.}

\item{num_observations}{Numeric value. Specify the number of observations if the \code{frequency="u"}.}

\item{save_path}{Specify where to save the `EViews` workfile.}
}
\value{
An EViews workfile
}
\description{
Use this function to create an `EViews` workfile from R
}
\examples{
library(EviewsR)
\dontrun{
eviews_wfcreate(wf="EviewsR_workfile",page="EviewsR_page",frequency = "m",start_date = "1990",
end_date = "2022")
}
}
\seealso{
eng_eviews, exec_commands, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfsave, export, import_table, import
}
\keyword{documentation}
