% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\title{Import \code{EViews} series to R as dataframe}
\usage{
import(object_name="",wf="",page="",options="",source_description="",
table_description="",keep_list="",drop_list="",keepmap_list="",dropmap_list="",
smpl_spec="")
}
\arguments{
\item{object_name}{Object name to be to store the imported \code{EViews} series.}

\item{wf}{Object or a character string representing the name of an `EViews` workfile.}

\item{page}{Object or a character string representing the name of an `EViews` workfile page.}

\item{options}{Object or a character string of any of the acceptable `EViews` \code{pagesave} options, such as \code{noid}, \code{nomapval}, \code{nonames}.}

\item{source_description}{The path and name of the file to be saved.}

\item{table_description}{Further description of the \code{source_description} such as specifying the \code{range=arg}, \code{byrow}.}

\item{keep_list}{Optional. Specify the list of `EViews` object to be saved.}

\item{drop_list}{Optional. Specify the list of `EViews` object to be dropped.}

\item{keepmap_list}{Optional. Specify the list of patterns of `EViews` object to be saved.}

\item{dropmap_list}{Optional. Specify the list of patterns of `EViews` object to be dropped.}

\item{smpl_spec}{Optional. Specify the `EViews` sample string}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} series to R as dataframe
}
\examples{
library(EviewsR)
\dontrun{
exec_commands(c("wfcreate(wf=Workfile,page=Page) m 1990 2022","genr y=rnd","genr x=rnd",
"save workfile","exit"))

import(object_name="myDataFrame",wf="workfile",drop_list = "y")
}
}
\seealso{
eng_eviews, exec_commands, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, export, \link{import_table}
}
\keyword{documentation}
