% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhyperCI_M.R
\name{WhyperCI_M_lower}
\alias{WhyperCI_M_lower}
\title{An Admissible Exact One-sided Lower Interval for the Number of White Balls in Hypergeometric Distribution}
\usage{
WhyperCI_M_lower(X, n, N, conf.level, details = FALSE)
}
\arguments{
\item{X}{integer representing the number of white balls we observed when drawn without replacement from an urn which contains both black and white balls.}

\item{n}{the number we drawn.}

\item{N}{integer representing the number of the whole balls in an urn.}

\item{conf.level}{the confidence level of confidence interval.}

\item{details}{TRUE/FALSE, can be abbreviate. Default is FALSE. If choose TRUE, the confidence intervals for the whole sample space and  the icp will be returned.}
}
\value{
a list which contains the confidence interval.
}
\description{
The 1-alpha Clopper-Pearson type lower interval for the
number of white balls in an urn.
}
\examples{
WhyperCI_M_lower(0,50,2000,0.95,details = TRUE)
WhyperCI_M_lower(0,50,2000,0.95)
}
\references{
Konijn, H. S. (1973). Statistical Theory of Sample Survey Design
and Analysis, Amsterdam: North-Holland.
}
