% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_definition.R
\docType{class}
\name{ExomeDepth-class}
\alias{ExomeDepth-class}
\title{Class \code{ExomeDepth}}
\description{
A class to hold the read count data that is used by ExomeDepth to call CNVs.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("ExomeDepth", data = NULL, test, reference, formula = 'cbind(test, reference) ~ 1', subset.for.speed = NULL)}.  \code{data} is optional and is
only used if the \code{formula} argument refers to covariates (in which case
these covariates must be included in the data frame).  \code{test} and
\code{reference} refer to the read count data for the test and reference
samples.

Critically, it is not required to store the positions of the DNA fragments
that led to the test and reference counts. That is only required for the
function \code{TestCNV}. If this is of use, a GRanges object can be provided
using the argument \code{positions}.

Creating a ExomeDepth object will automatically fit the
beta-binomial model (using routines from the \code{aod} package) and compute
the likelihood for the three copy number states (normal, deletion and
duplication).
}

\examples{
showClass("ExomeDepth")
}
\references{
A robust model for read count data in exome sequencing experiments and implications for copy number variant calling, Plagnol et al 2012
}
\seealso{
\code{?select.reference.set} \code{?CallCNVs}
}
\keyword{classes}
