% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_blxAlphaBeta.R
\name{recombination_blxAlphaBeta}
\alias{recombination_blxAlphaBeta}
\title{Blend Alpha Beta recombination for DE}
\usage{
recombination_blxAlphaBeta(X, M, recpars)
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/blxAlphaBeta" (Blend Alpha Beta) recombination for the ExpDE 
framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_blxAlpha()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{alpha} : extrapolation parameter for 'best' parent vector.\cr
   Accepts real value \code{0 <= alpha <= 0.5}.
   \item \code{beta} : extrapolation parameter for 'worst' parent vector.\cr
   Accepts real value \code{0 <= beta <= 0.5}. 
}

 @section Warning:
 This recombination operator evaluates the candidate solutions in \code{M}, 
 which adds an extra \code{popsize} evaluations per iteration.
}

\section{References}{

F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3) 309-338, 2003.
}

