% Generated by roxygen2 (4.0.0): do not edit by hand
\name{eDist}
\alias{AIC.eDist}
\alias{BIC.eDist}
\alias{eDist}
\alias{logLik.eDist}
\alias{print.eDist}
\alias{vcov.eDist}
\title{S3 methods from manuplating eDist objects.}
\usage{
\method{logLik}{eDist}(object, ...)

\method{AIC}{eDist}(object, ..., k = 2)

\method{BIC}{eDist}(object, ...)

\method{vcov}{eDist}(object, ..., corr = FALSE)

\method{print}{eDist}(x, ...)
}
\arguments{
\item{object,x}{a eDist object, which is the output of the parameter estimation functions.}

\item{...}{other parameters}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is the classical AIC.}

\item{corr}{logic, if the vcov return correlation matrix (instead of variance-covariance matrix)
or not.}
}
\description{
S3 methods from manuplating eDist objects
}
\details{
S3 methods from manuplating eDist objects.
}
\examples{
\donttest{
X <- rnorm(20)
est.par <- eNormal(X, method ="numerical.MLE")
logLik(est.par)
AIC(est.par)
BIC(est.par)
vcov(est.par)
vcov(est.par,corr=TRUE)
print(est.par)
}
}
\author{
A. Jonathan R. Godfrey and Haizhen Wu
}

