% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Beta_ab}
\alias{Beta_ab}
\alias{dBeta_ab}
\alias{eBeta_ab}
\alias{lBeta_ab}
\alias{pBeta_ab}
\alias{qBeta_ab}
\alias{rBeta_ab}
\alias{sBeta_ab}
\title{The four-Parameter beta Distribution.}
\usage{
dBeta_ab(x, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

pBeta_ab(q, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

qBeta_ab(p, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

rBeta_ab(n, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

eBeta_ab(X, w, method = "numerical.MLE")

lBeta_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), logL = TRUE)

sBeta_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{shape1,shape2}{shape parameters.}

\item{a,b}{boundary parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta_ab gives log likelihood.}

\item{...}{other parameters}
}
\value{
dBeta_ab gives the density; pBeta_ab gives the distribution function;
qBeta_ab gives the quantile function; rBeta_ab generates random variables;
eBeta_ab estimate the parameters; sBeta_ab gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the 4 Parameter beta distribution
}
\details{
four-Parameter beta Distribution

See \href{../doc/Distributions-Four-Parameter-Beta.html}{Distributions-Four-Parameter-Beta}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
shape1 <- 2
shape2 <- 5
X <- rBeta_ab(n, shape1, shape2, a, b)
(est.par <- eBeta_ab(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dBeta_ab(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qBeta_ab((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pBeta_ab(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=2, shape2=5, a= 1, b=2)
X <- rBeta_ab(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eBeta_ab(X,w) # estimated parameters of weighted sample
eBeta_ab(X) # estimated parameters of unweighted sample

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rBeta_ab,edist=eBeta_ab,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5, a=0, b=1), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rBeta_ab(1000, shape1, shape2, a, b)
(est.par <- eBeta_ab(X))
H <- attributes(eBeta_ab(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lBeta_ab(X,param = est.par)
lBeta_ab(X,param = est.par, logL=FALSE)
sBeta_ab(X,param = est.par)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

