% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SRTB_ab.R
\name{SRTB_ab}
\alias{SRTB_ab}
\alias{dSRTB_ab}
\alias{eSRTB_ab}
\alias{lSRTB_ab}
\alias{pSRTB_ab}
\alias{qSRTB_ab}
\alias{rSRTB_ab}
\title{The symmetric-reflected truncated beta (SRTB) distribution.}
\usage{
dSRTB_ab(x, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), ...)

pSRTB_ab(q, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1), ...)

qSRTB_ab(p, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1), ...)

rSRTB_ab(n, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), ...)

eSRTB_ab(X, w, method = "numerical.MLE", ...)

lSRTB_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{shape1,shape2}{Shape parameters.}

\item{a,b}{Boundary parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical; if TRUE, lSRTB_ab gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dSRTB_ab gives the density, pSRTB_ab the distribution function,
qSRTB_ab gives the quantile function, rSRTB_ab generates random variables, and
eSRTB_ab estimates the parameters. lSRTB_ab provides the log-likelihood function and sSRTB_ab the score function.
}
\description{
Density, distribution, quantile, random number
generation and parameter estimation functions for the SRTB distribution.
Parameter estimation can be based on a weighted or unweighted i.i.d. sample and can be carried out numerically.
}
\details{
No details as of yet.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rSRTB_ab(n=500, shape1=2, shape2=10, a=1, b=2)
est.par <- eSRTB_ab(X)
plot(est.par)

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# log-likelihood function
lSRTB_ab(X,param = est.par)
}
\author{
Haizhen Wu.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

