% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bestDist.R
\name{bestDist}
\alias{bestDist}
\title{Finding the best distribution for a (weighted) sample.}
\usage{
bestDist(X, w = rep(1, length(X))/length(X), candDist = c("Beta_ab",
  "Laplace", "Normal"), criterion = c("AICc", "logLik", "AIC", "BIC", "MDL"))
}
\arguments{
\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{candDist}{A vector of candidate distributions.}

\item{criterion}{The basis on which the best fitted distribution is chosen.}
}
\value{
An object of class character containing the name of the best distribution and its corresponding parameter estimates.
}
\description{
This function chooses the best fitted distribution, based on
a specified criterion.
}
\details{
When comparing models fitted by maximum likelihood to the same data, the smaller the AIC, BIC or MDL, the better the fit.
When comparing models using the log-likelihood criterion, the larger the log-likelihood the better the fit.
}
\note{
The MDL criterion only works for parameter estimation by numerical maximum likelihood.
}
\examples{
X <- rBeta_ab(30, a = 0, b = 1, shape1 = 2, shape2 = 10)

# Determining the best distribution from the list of candidate distributions for the data X
Best.Dist <- bestDist(X, candDist = c("Laplace","Normal","Beta_ab"), criterion = "logLik")

# Printing the parameter estimates of the best distribution
attributes(Best.Dist)$best.dist.par
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.
}

