% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDEA.R
\name{IDEA}
\alias{IDEA}
\title{Idea - Isolated Effect on Assignment}
\description{
\code{IDEA} with a soft label predictor (sIDEA) \cr
tacks changes the soft label of being assigned to each existing cluster
throughout a (multidimensional) feature space
\code{IDEA} with a hard label predictor (hIDEA) \cr
tacks changes the soft label of being assigned to each existing cluster
throughout a (multidimensional) feature space
}
\details{
\code{IDEA} for soft labeling algorithms (sIDEA) indicates the soft label that an
observation \eqn{\textbf{x}} with replaced values \eqn{\tilde{\textbf{x}}_S} is assigned to
the k-th cluster. \code{IDEA} for hard labeling algorithms (hIDEA) indicates
the cluster assignment of an observation \eqn{\textbf{x}} with replaced values
\eqn{\tilde{\textbf{x}}_S}. \cr

The global \code{IDEA} is denoted by the corresponding data set X:
\deqn{
\text{sIDEA}_X(\tilde{\textbf{x}}_S) = \left(\frac{1}{n} \sum_{i = 1}^n
\text{sIDEA}^{(1)}_{\textbf{x}^{(i)}}(\tilde{\textbf{x}}_S), \dots, \frac{1}{n}
\sum_{i = 1}^n \text{sIDEA}^{(k)}_{\textbf{x}^{(i)}}(\tilde{\textbf{x}}_S) \right)
}
where the c-th vector element is the average c-th vector element of local
sIDEA functions. The global hIDEA corresponds to:
\deqn{
\text{hIDEA}_X(\tilde{\textbf{x}}_S) =  \left(\frac{1}{n}\sum_{i = 1}^n
\mathbb{1}_{1}(\text{hIDEA}_{\textbf{x}^{(i)}}(\tilde{\textbf{x}}_S)), \dots,
\frac{1}{n}\sum_{i = 1}^n \mathbb{1}_{k}(\text{hIDEA}_{\textbf{x}^{(i)}}(\tilde{\textbf{x}}_S))\right)
}
where the c-th vector element is the fraction of hard label
reassignments to the c-th cluster.
}
\examples{
\donttest{
# load data and packages
require(factoextra)
require(FuzzyDBScan)
multishapes = as.data.frame(multishapes[, 1:2])
# Set up an train FuzzyDBScan
eps = c(0, 0.2)
pts = c(3, 15)
res = FuzzyDBScan$new(multishapes, eps, pts)
res$plot("x", "y")
# create soft label predictor
predict_prob = function(model, newdata) model$predict(new_data = newdata)
predictor = ClustPredictor$new(res, as.data.frame(multishapes), y = res$results,
                                    predict.function = predict_prob, type = "prob")
# Calculate `IDEA` global and local for feature "x"
idea_x = IDEA$new(predictor = predictor, feature = "x", grid.size = 5)
idea_x$plot_globals(0.5) # plot global effect of all clusters with 50 percent of local mass.
}
}
\seealso{
\link[iml:FeatureEffects]{iml::FeatureEffects}, \link[iml:FeatureEffects]{iml::FeatureEffects}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{predictor}}{\link{ClustPredictor}\cr
The object (created with \code{ClustPredictor$new()}) holding
the cluster algorithm and the data.}

\item{\code{feature}}{(\verb{character or list})\cr
Features/ feature sets to calculate the effect curves.}

\item{\code{method}}{\code{character(1)}\cr
The \code{IDEA} method to be used.}

\item{\code{mg}}{\code{DataGenerator}\cr
A \code{MarginalGenerator} object to sample and generate
the pseudo instances.}

\item{\code{results}}{\code{data.table}\cr
The \code{IDEA} results.}

\item{\code{noise.out}}{any \cr
Indicator for the noise variable.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{type}}{function \cr
Detect the type in the predictor}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IDEA-new}{\code{IDEA$new()}}
\item \href{#method-IDEA-plot}{\code{IDEA$plot()}}
\item \href{#method-IDEA-plot_globals}{\code{IDEA$plot_globals()}}
\item \href{#method-IDEA-clone}{\code{IDEA$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IDEA-new"></a>}}
\if{latex}{\out{\hypertarget{method-IDEA-new}{}}}
\subsection{Method \code{new()}}{
Create an \link{IDEA} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IDEA$new(predictor, feature, method = "g+l", grid.size = 20L, noise.out = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{\link{ClustPredictor}\cr
The object (created with \code{ClustPredictor$new()}) holding
the cluster algorithm and the data.}

\item{\code{feature}}{(\verb{character or list})\cr
For which features do you want importance scores calculated. The default
value of \code{NULL} implies all features. Use a named list of character vectors
to define groups of features for which joint importance will be calculated.}

\item{\code{method}}{\code{character(1)}\cr
The \code{IDEA} method to be used. Possible choices for the method are:\cr
\code{"g+l"} (default): store global and local \code{IDEA} results

\code{"local"}: store only local \code{IDEA} results

\code{"global"}: store only global \code{IDEA} results

\code{"init_local"}: store only local \code{IDEA} results and
additional reference for the observations initial
assigned cluster.

\code{"init_g+l"} store global and local \code{IDEA} results and
additional reference for the observations initial
assigned cluster.}

\item{\code{grid.size}}{\verb{(numeric(1) or NULL)} \cr
size of the grid to replace values. If grid size is
given, an equidistant grid is create. If \code{NULL}, values
are calculated at all present combinations of feature values.}

\item{\code{noise.out}}{any \cr
Indicator for the noise variable. If not NULL, noise will
be excluded from the effect estimation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(data.frame)\cr
Values for the effect curves: \cr
One row per grid per instance for each local idea
estimation. If \code{method} includes global estimation, one
additional row per grid point.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IDEA-plot"></a>}}
\if{latex}{\out{\hypertarget{method-IDEA-plot}{}}}
\subsection{Method \code{plot()}}{
Plot an \link{IDEA} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IDEA$plot(c = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{indicator for the cluster to plot. If \code{NULL},
all clusters are plotted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(ggplot)\cr
A ggplot object that depends on the \code{method} chosen.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IDEA-plot_globals"></a>}}
\if{latex}{\out{\hypertarget{method-IDEA-plot_globals}{}}}
\subsection{Method \code{plot_globals()}}{
Plot the global sIDEA curves of all clusters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IDEA$plot_globals(mass = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mass}}{between 0 and 1. The percentage of local \code{IDEA}
curves to plot a certainty interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(ggplot)\cr
A ggplot object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IDEA-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IDEA-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IDEA$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
