% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{MSVP}
\alias{MSVP}
\title{Mean Saturation Vapour Pressure (e_s)}
\usage{
MSVP(T_max, T_min)
}
\arguments{
\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}

\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}
}
\value{
The function returns the value of the mean saturation vapour pressure [kPa] as a numeric scalar.
}
\description{
\code{MSVP} returns the value of mean saturation vapour pressure.
}
\details{
This is a function to calculate the mean saturation vapour pressure [kPa].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
MSVP(T_max = 35, T_min = 1)

}
\seealso{
\code{\link{SatVP}}.
}
