% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{FCVARboot}
\alias{FCVARboot}
\title{Bootstrap Likelihood Ratio Test}
\usage{
FCVARboot(x, k, r, optRES, optUNR, B)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.}

\item{k}{The number of lags in the system.}

\item{r}{The cointegrating rank.}

\item{optRES}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options
for the restricted model, as generated from \code{FCVARoptions()},
with adjustments as necessary.}

\item{optUNR}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options
for the unrestricted model.}

\item{B}{The number of bootstrap samples.}
}
\value{
A list \code{FCVARboot_stats} containing the estimation results,
including the following parameters:
\describe{
  \item{\code{LRbs}}{A \eqn{B x 1} vector of simulated likelihood ratio statistics}
  \item{\code{pv}}{An approximate p-value for the likelihood ratio statistic
   based on the bootstrap distribution.}
  \item{\code{H}}{A list containing the likelihood ratio test results.
  It is identical to the output from \code{FCVARhypoTest}, with one addition,
  namely \code{H$pvBS} which is the bootstrap p-value}
  \item{\code{mBS}}{The model estimates under the null hypothesis.}
  \item{\code{mUNR}}{The model estimates under the alternative hypothesis.}
}
}
\description{
\code{FCVARboot} generates a distribution of a likelihood ratio
test statistic using a wild bootstrap, following the method of
Boswijk, Cavaliere, Rahbek, and Taylor (2016). It takes two sets
of options as inputs to estimate the model under the null and the
unrestricted model.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
opt$plotRoots <- 0
optUNR <- opt
optRES <- opt
optRES$R_Beta <- matrix(c(1, 0, 0), nrow = 1, ncol = 3)
set.seed(42)
FCVARboot_stats <- FCVARboot(x, k = 2, r = 1, optRES, optUNR, B = 2)
# In practice, set the number of bootstraps so that (B+1)*alpha is an integer,
# where alpha is the chosen level of significance.
# For example, set B = 999 (but it takes a long time to compute).
}
}
\references{
Boswijk, Cavaliere, Rahbek, and Taylor (2016)
"Inference on co-integration parameters in heteroskedastic
vector autoregressions," Journal of Econometrics 192, 64-85.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} is called to estimate the models under the null and alternative hypotheses.

Other FCVAR postestimation functions: 
\code{\link{FCVARhypoTest}()},
\code{\link{GetCharPolyRoots}()},
\code{\link{MVWNtest}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.FCVAR_roots}()},
\code{\link{summary.MVWN_stats}()}
}
\concept{FCVAR postestimation functions}
