% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_aux.R
\name{FCVARlikeGrid}
\alias{FCVARlikeGrid}
\title{Grid Search to Maximize Likelihood Function}
\usage{
FCVARlikeGrid(x, k, r, opt)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.}

\item{k}{The number of lags in the system.}

\item{r}{The cointegrating rank.}

\item{opt}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
generated from \code{FCVARoptions()}.}
}
\value{
An S3 object of type \code{FCVAR_grid} containing the optimization results,
including the following parameters:
\describe{
  \item{\code{params}}{A vector \code{params} of \code{d} and \code{b}
  (and \code{mu} if level parameter is selected)
  corresponding to a maximum over the grid of \code{c(d,b)} or \code{phi}.}
  \item{\code{dbHatStar}}{A vector of \code{d} and \code{b}
  corresponding to a maximum over the grid of \code{c(d,b)} or \code{phi}.}
  \item{\code{muHatStar}}{A vector of the optimal \code{mu} if level parameter is selected. }
  \item{\code{Grid2d}}{An indicator for whether or not the optimization
  is conducted over a 2-dimensional parameter space,
  i.e. if there is no equality restriction on \code{d} and \code{b}.}
  \item{\code{dGrid}}{A vector of the grid points in the parameter \code{d},
    after any transformations for restrictions, if any.}
  \item{\code{bGrid}}{A vector of the grid points in the parameter \code{b},
    after any transformations for restrictions, if any.}
  \item{\code{dGrid_orig}}{A vector of the grid points in the parameter \code{d},
    in units of the fractional integration parameter.}
  \item{\code{bGrid_orig}}{A vector of the grid points in the parameter \code{b},
    in units of the fractional integration parameter.}
  \item{\code{like}}{The maximum value of the likelihood function over the chosen grid.}
  \item{\code{k}}{The number of lags in the system.}
  \item{\code{r}}{The cointegrating rank.}
  \item{\code{opt}}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
    generated from \code{FCVARoptions()}.}
}
}
\description{
\code{FCVARlikeGrid} performs a grid-search optimization
by calculating the likelihood function
on a grid of candidate parameter values.
This function evaluates the likelihood over a grid of values
	for \code{c(d,b)} (or \code{phi}).
	It can be used when parameter estimates are sensitive to
	starting values to give an approximation of the global maximum that can
	then be used as the starting value in the numerical optimization in
	\code{FCVARestn}.
	\code{plot.FCVAR_grid} plots the likelihood function from \code{FCVARlikeGrid}.
}
\note{
If \code{opt$LocalMax == 0}, \code{FCVARlikeGrid} returns the parameter values
      corresponding to the global maximum of the likelihood on the grid.
      If \code{opt$LocalMax == 1}, \code{FCVARlikeGrid} returns the parameter values for the
      local maximum corresponding to the highest value of \code{b}. This
      alleviates the identification problem mentioned in Johansen and
      Nielsen (2010, section 2.3).
}
\examples{
# Restrict equality of fractional parameters.
\donttest{
opt <- FCVARoptions()
opt$dbStep1D     <- 0.2 # Coarser grid for plotting example.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
opt$restrictDB   <- 1 # impose restriction d=b ? 1 <- yes, 0 <- no.
opt$progress     <- 2 # Show progress report on each value of b.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
likeGrid_params <- FCVARlikeGrid(x, k = 2, r = 1, opt)
plot(likeGrid_params)
}

# Linear restriction on fractional parameters.
\donttest{
opt <- FCVARoptions()
opt$dbStep1D     <- 0.2 # Coarser grid for plotting example.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
opt$restrictDB   <- 0 # impose restriction d=b ? 1 <- yes, 0 <- no.
# Impose linear restriction on d and b:
opt$R_psi        <- matrix(c(2, -1), nrow = 1, ncol = 2)
opt$r_psi        <- 0.5
opt$progress     <- 2 # Show progress report on each value of b.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
likeGrid_params <- FCVARlikeGrid(x, k = 2, r = 1, opt)
plot(likeGrid_params)
}

# Constrained 2-dimensional optimization.
# Impose restriction dbMax >= d >= b >= dbMin.
\donttest{
opt <- FCVARoptions()
opt$dbStep1D     <- 0.2 # Coarser grid for plotting example.
opt$dbStep2D     <- 0.2 # Coarser grid for plotting example.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 1 # impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
opt$restrictDB   <- 0 # impose restriction d=b ? 1 <- yes, 0 <- no.
opt$progress     <- 2 # Show progress report on each value of b.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
likeGrid_params <- FCVARlikeGrid(x, k = 2, r = 1, opt)
}

# Unconstrained 2-dimensional optimization.
\donttest{
opt <- FCVARoptions()
opt$dbStep1D     <- 0.1 # Coarser grid for plotting example.
opt$dbStep2D     <- 0.2 # Coarser grid for plotting example.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
opt$restrictDB   <- 0 # impose restriction d=b ? 1 <- yes, 0 <- no.
opt$progress     <- 2 # Show progress report on each value of b.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
likeGrid_params <- FCVARlikeGrid(x, k = 2, r = 1, opt)
}
}
\references{
Johansen, S. and M. \enc{Ø}{O}. Nielsen (2010).
"Likelihood inference for a nonstationary fractional
autoregressive model," Journal of Econometrics 158, 51-66.
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{plot.FCVAR_grid} plots the likelihood function from \code{FCVARlikeGrid}.

Other FCVAR auxiliary functions: 
\code{\link{FCVARforecast}()},
\code{\link{FCVARsimBS}()},
\code{\link{FCVARsim}()},
\code{\link{FracDiff}()},
\code{\link{plot.FCVAR_grid}()}
}
\concept{FCVAR auxiliary functions}
