% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_threshold_factor_grid.R
\name{fftrees_threshold_factor_grid}
\alias{fftrees_threshold_factor_grid}
\title{Performs a grid search over factor and returns accuracy statistics for a given factor cue}
\usage{
fftrees_threshold_factor_grid(
  thresholds = NULL,
  cue_v = NULL,
  criterion_v = NULL,
  directions = "=",
  sens.w = 0.5,
  cost.outcomes = list(hi = 0, fa = 1, mi = 1, cr = 0),
  cost.each = 0,
  goal.threshold = "bacc"
)
}
\arguments{
\item{thresholds}{numeric. A vector of factor thresholds to consider}

\item{cue_v}{numeric. Feature values}

\item{criterion_v}{logical. Criterion values}

\item{directions}{character. Character vector of threshold directions to consider.}

\item{sens.w}{numeric.}

\item{cost.outcomes}{list. A list of length 4 with names 'hi', 'fa', 'mi', and 'cr' specifying the costs of a hit, false alarm, miss, and correct rejection rspectively. E.g.; \code{cost.outcomes = listc("hi" = 0, "fa" = 10, "mi" = 20, "cr" = 0)} means that a false alarm and miss cost 10 and 20 respectively while correct decisions have no cost.}

\item{cost.each}{numeric.}

\item{goal.threshold}{character.}
}
\description{
Performs a grid search over factor and returns accuracy statistics for a given factor cue
}
