% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Match.R
\name{MATCH}
\alias{MATCH}
\title{Get Matched Units Given Certain Covariate Combination}
\usage{
MATCH(FLAME_object, cov_name, cov_val)
}
\arguments{
\item{FLAME_object}{object returned by applying the FLAME algorithm
(\code{\link{FLAME_bit}} or \code{\link{FLAME_PostgreSQL}} or
\code{\link{FLAME_SQLite}})}

\item{cov_name}{a vector of covariate names}

\item{cov_val}{a vector of covariate values, where the value position should match cov_name position}
}
\value{
data frame with all matched units
}
\description{
Get Matched Units Given Certain Covariate Combination
}
\examples{
data(toy_data)
result <- FLAME::FLAME_bit(data = toy_data, holdout = toy_data)
FLAME::MATCH(FLAME_object = result, cov_name = c("X1", "X2"), cov_val = c("2", "2"))
}
