% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bcFuns.R
\name{bcFuns}
\alias{bcFuns}
\title{Creates a function for a specific back-calculation model.}
\usage{
bcFuns(BCM, msg = FALSE)
}
\arguments{
\item{BCM}{A single numeric between 1 and 22 or a string that indicates which back-calculation model to use (based on numbers and names in Vigliola and Meekan (2009)).}

\item{msg}{A logical that indicates whether a message about the model and parameter definitions should be output.}
}
\value{
A function that can be used to predict length at previous age (Li) given length-at-capture (Lc), hard-part radius-at-age i (Ri), and hard-part radius-at-capture (Rc).  In addition, some functions/models may require the previous age (agei) and the age-at-capture (agec), certain parameters related to the biological intercept (R0p & L0p), or certain parameters estimated from various regression models (a,b,c,A,B,C).  See source for more information.
}
\description{
Creates a function for a specific back-calculation model based on definitions in Vigloila and Meekan (2009).
}
\details{
The following back-calculation models, based on definitions with abbreviations and model numbers from Vigloila and Meekan (2009), are supported.

\tabular{ccl}{
\bold{Abbreviation} \tab \bold{Number} \tab \bold{Model} \cr
DALE \tab 1 \tab Dahl-Lea \cr
FRALE \tab 2 \tab Fraser-Lee \cr
BI, LBI \tab 3 \tab (Linear) Biological Intercept \cr
BPH, LBPH \tab 4 \tab (Linear) Body Proportional Hypothesis \cr
TVG \tab 5 \tab Time-Varying Growth \cr
SPH, LSPH \tab 6 \tab (Linear) Scale Proportional Hypothesis \cr
AE, AESPH \tab 7 \tab (Age Effect) Scale Proportional Hypothesis \cr
AEBPH \tab 8 \tab (Age Effect) Body Proportional Hypothesis \cr
MONA \tab 9 \tab Monastyrsky \cr
MONA-BPH \tab 10 \tab Monastyrsky Body Proportional Hypothesis \cr
MONA-SPH \tab 11 \tab Monastyrsky Scale Proportional Hypothesis \cr
WAKU \tab 12 \tab Watanabe and Kuroki \cr
FRY \tab 13 \tab Fry \cr
MF, ABI \tab 14 \tab Modified Fry, Allometric Biological Intercept \cr
FRY-BPH, ABPH \tab 15 \tab Fry, Allometric Body Proportional Hypothesis \cr
FRY-SPH, ASPH \tab 16 \tab Fry, Allometric Scale Proportional Hypothesis \cr
QBPH \tab 17 \tab Quadratic Body Proportional Hypothesis \cr
QSPH \tab 18 \tab Quadratic Scale Proportional Hypothesis \cr
PBPH \tab 19 \tab Polynomial Body Proportional Hypothesis \cr
PSPH \tab 20 \tab Polynomial Scale Proportional Hypothesis \cr
EBPH \tab 21 \tab Exponential Body Proportional Hypothesis \cr
ESPH \tab 22 \tab Exponential Scale Proportional Hypothesis \cr
}
}
\section{fishR vignette}{
 \url{https://sites.google.com/site/fishrfiles/gnrl/Backcalculation.pdf},
\url{https://sites.google.com/site/fishrfiles/gnrl/BackcalculationExtra.pdf}
}
\examples{
## Simple Examples
( bcm1 <- bcFuns(1) )
bcm1(20,10,40)

## Example with dummy length-at-cap, radii-at-cap, and radii-at-age
lencap <- c(100,100,100,150,150)
radcap <- c(20,20,20,30,30)
rad    <- c( 5,10,15,15,25)
bcm1(lencap,rad,radcap)

( bcm2 <- bcFuns("FRALE") )
bcm2(lencap,rad,radcap,2)  # demonstrated with a=2
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Vigliola, L. and M.G. Meekan.  2009.  The back-calculation of fish growth from otoliths.  pp. 174-211.  in B.S. Green et al. (editors).  \href{https://www.researchgate.net/publication/226394736_The_Back-Calculation_of_Fish_Growth_From_Otoliths}{Tropical Fish Otoliths: Information for Assessment, Management and Ecology.}  Review: Methods and Technologies in Fish Biology and Fisheries 11.  Springer.
}
\keyword{manip}

