% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthModels.R
\name{Schnute}
\alias{Schnute}
\title{The four-parameter growth function from Schnute (1981).}
\usage{
Schnute(t, case = 1, t1 = NULL, t3 = NULL, L1 = NULL, L3 = NULL,
  a = NULL, b = NULL)
}
\arguments{
\item{t}{A numeric vector of ages over which to model growth.}

\item{case}{A string that indicates the case of the Schnute growth function to use.}

\item{t1}{The (young) age that corresponds to \code{L1}.  Set to minimum value in \code{t} by default.}

\item{t3}{The (old) age that corresponds to \code{L3}.  Set to maximum value in \code{t} by default.}

\item{L1}{The mean size/length at \code{t1}.}

\item{L3}{The mean size/length at \code{t3}.}

\item{a}{A dimensionless parameter that is related to the time/age at the inflection point.}

\item{b}{A dimensionless parameter that is related to size/length at the inflection point.}
}
\value{
\code{Schnute} returns a predicted size given the case of the function and the provided parameter values.

\code{SchnuteModels} returns a graphic that uses \code{\link{plotmath}} to show the growth function equation in a pretty format.
}
\description{
The four-parameter growth function from Schnute (1981).
}
\section{IFAR Chapter}{
 None specifically, but 12-Individual Growth is related.
}
\examples{
## See the formulae
growthFunShow("Schnute",1,plot=TRUE)
growthFunShow("Schnute",2,plot=TRUE)
growthFunShow("Schnute",3,plot=TRUE)
growthFunShow("Schnute",4,plot=TRUE)

## Simple examples
ages <- 1:15
s1 <- Schnute(ages,case=1,t1=1,t3=15,L1=30,L3=400,a=0.3,b=1)
s2 <- Schnute(ages,case=2,t1=1,t3=15,L1=30,L3=400,a=0.3,b=1)
s3 <- Schnute(ages,case=3,t1=1,t3=15,L1=30,L3=400,a=0.3,b=1)
s4 <- Schnute(ages,case=4,t1=1,t3=15,L1=30,L3=400,a=0.3,b=1)

plot(s1~ages,type="l",lwd=2)
lines(s2~ages,lwd=2,col="red")
lines(s3~ages,lwd=2,col="blue")
lines(s4~ages,lwd=2,col="green")

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Schnute, J.  1981.  A versatile growth model with statistical stable parameters.  Canadian Journal of Fisheris and Aquatic Sciences 38:1128-1140.
}
\seealso{
See \code{\link{vbFuns}}, \code{\link{GompertzFuns}}, \code{\link{RichardsFuns}}, and \code{\link{logisticFuns}} for similar functionality for other models.
}
\keyword{manip}

