% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WalleyeWad.R
\docType{data}
\name{WalleyeWad}
\alias{WalleyeWad}
\title{Catches-at-age for male and female Walleye from Lake Winnebago, WI, 2010.}
\format{A data frame with 18 observations on the following 3 variables.
 \describe{
   \item{age}{Age (yrs; from pectoral fin ray)}
   \item{numF}{Number of captured females}
   \item{numM}{Number of captured males}
 }}
\source{
From Koenigs, R.P., Bruch, R.M., Stelzer, R.S., and Kamke, K.K. 2015. Validation of otolith ages for Walleye (\emph{Sander vitreus}) in the Winnebago System.  Fisheries Research, 167:13-21.  Obtained directly from Ryan Koenigs.
}
\description{
Catches-at-age for male and female Walleye from Lake Winnebago, WI, 2010.
}
\details{
Koenigs et al. (2015) captured adult Walleye from Lake Winnebago during spawning assessments in 2010. The sex was recorded and ages were estimated from sectioned otoliths for each fish. Koenigs et al. (2015) fit separate catch curves to female and male Walleye.
}
\note{
Used in the \href{http://derekogle.com/IFAR/}{Introductory Fisheries Analyses with R} book.
}
\section{Topic(s)}{

 \itemize{
   \item Mortality
   \item Catch Curve
 }
}
\examples{
data(WalleyeWad)
str(WalleyeWad)
head(WalleyeWad)
plot(numF~age,data=WalleyeWad)
points(numM~age,data=WalleyeWad,pch=19)

}
\concept{
'Catch Curve' Mortality
}
\keyword{datasets}

