% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef}
\alias{ranef}
\title{Random effects estimates for joint models}
\usage{
ranef(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a matrix of random effects estimates.
}
\description{
Extracts the posterior mean of the random effects for a fitted joint model.
}
\examples{
\donttest{
# a joint model fit
fit <- jmcs(ydata = ydata, cdata = cdata, 
long.formula = response ~ time + x1, 
surv.formula = Surv(surv, failure_type) ~ x1 + x2, 
random =  ~ time| ID)

# extract random effects estimates
head(ranef(fit))
}
}
\seealso{
\code{\link{jmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
