% Generated by roxygen2 (4.0.1): do not edit by hand
\name{aw2k}
\alias{aw2d}
\alias{aw2e}
\alias{aw2k}
\alias{de2k}
\alias{kd2a}
\alias{kd2e}
\alias{kd2w}
\alias{ke2a}
\alias{ke2d}
\alias{ke2w}
\title{Local Conversion Functions Between Kiener Distribution Parameters}
\usage{
aw2k(a, w)

aw2d(a, w)

aw2e(a, w)

kd2a(k, d)

kd2w(k, d)

ke2a(k, e)

ke2w(k, e)

ke2d(k, e)

kd2e(k, d)

de2k(d, e)
}
\arguments{
\item{a}{a numeric value.}

\item{k}{a numeric value.}

\item{w}{a numeric value.}

\item{d}{a numeric value.}

\item{e}{a numeric value.}
}
\description{
Conversion functions between parameters \code{a}, \code{k}, \code{w},
\code{d}, \code{e} used in Kiener distributions of type II, III and IV.
}
\details{
\code{a} (alpha) is the left tail parameter,
\code{w} (omega) is the right tail parameter,
\code{d} (delta) is the distorsion parameter,
\code{e} (epsilon) is the eccentricity parameter.

\code{k} (kappa) is the harmonic mean of \code{a} and \code{w} and
describes a global tail parameter.

They are defined by:
\deqn{ aw2k(a, w) = 2 / (1/a + 1/w) = k }
\deqn{ aw2d(a, w) = (-1/a + 1/w) / 2 = d }
\deqn{ aw2e(a, w) = (a - w) / (a + w) = e }
\deqn{ kd2a(k, d) = 1 / ( 1/k - d) = a }
\deqn{ kd2w(k, d) = 1 / ( 1/k + d) = w }
\deqn{ ke2a(k, e) = k / (1 - e) = a }
\deqn{ ke2w(k, e) = k / (1 + e) = w }
\deqn{ ke2d(k, e) = e / k = d }
\deqn{ kd2e(k, d) = k * d = e }
\deqn{ de2k(k, e) = e / d = k }
\code{aw2k} is equivalent to the harmonic mean.
}
\examples{
aw2k(4, 6); aw2d(4, 6); aw2e(4, 6)
outer(1:6, 1:6, aw2k)
}
\seealso{
The asymmetric Kiener distributions of type II, III and IV:
\code{\link{kiener2}}, \code{\link{kiener3}}, \code{\link{kiener4}}
}

