% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovariateData.R
\name{isCovariateData}
\alias{isCovariateData}
\title{Check whether an object is a CovariateData object}
\usage{
isCovariateData(x)
}
\arguments{
\item{x}{The object to check.}
}
\value{
A logical value.
}
\description{
Check whether an object is a CovariateData object
}
\examples{
\donttest{
andromedaVersion <- utils::packageVersion("Andromeda")
if (andromedaVersion < "1.0.0") {
  binaryCovDataFile <- system.file("testdata/binaryCovariateData.zip",
    package = "FeatureExtraction"
  )
} else {
  binaryCovDataFile <- system.file("testdata/binaryCovariateDataDuckDB.zip",
    package = "FeatureExtraction"
  )
}
covData <- loadCovariateData(binaryCovDataFile)
isCovData <- isCovariateData(covData)
}

}
