% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Mean squared error}
\usage{
mse(observados, estimados, k)
}
\arguments{
\item{observados}{vector of values observed.}

\item{estimados}{vector of regression model data.}

\item{k}{the number of model parameters}
}
\description{
the MSE is the mean of the square of the errors, corresponding to the expected value of the squared error loss or quadratic loss. The difference occurs because of randomness or because the estimator doesn't account for information that could produce a more accurate estimate.
}
\details{
mse = (sum(estimados-observados)^2)/(length(observados)-k)
}
\references{
See \url{https://en.wikipedia.org/wiki/Mean_squared_error} for more details.
}

