% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05.1.network_methods.R
\name{network_methods}
\alias{network_methods}
\alias{edgecount}
\alias{network.size}
\alias{vertex.names}
\alias{plot_network}
\title{Extending \code{newtwork} functions to \code{newtwork_financial} objects}
\usage{
edgecount(x, ...)

network.size(x, ...)

vertex.names(x, ...)

plot_network(x, ...)
}
\arguments{
\item{x}{The \code{newtwork_financial} object}

\item{...}{Other parameters passed to the corresponding \code{newtwork} functions (see Details).}
}
\value{
The same result for both \code{newtwork} and \code{newtwork_financial} objects
\itemize{
 \item \code{edgecount}: Number of edges, numeric scalar
 \item \code{vertex.names}: Names/Labels of the vertices, character vector
 \item \code{network.size}: Number of vertices, numeric scalar
 \item \code{plot_network}: Returns a two-column matrix containing the vertex positions as \code{(x,y)} coordinates, invisibly. Called to print the graph to any \code{R} device.)
}
}
\description{
The following functions are implemented:
\itemize{
 \item \code{edgecount} to count the number of eges (\code{network::network.edgecount});
 \item \code{vertex.names} to retrieve the vertices' names (\code{network::network.vertex.names});
 \item \code{network.size} to count the edges (\code{network::network::network.size});
 \item \code{plot_network} to plot networks (\code{network::plot.network}))
}
}
\details{
Implementing most basic iterators from the package \code{newtwork} for objects of class \code{newtwork_financial}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
