% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.metric.R
\name{screen.metric}
\alias{screen.metric}
\title{Plot a metric with trend and change points}
\usage{
screen.metric(y, ylabel = "", text = NULL)
}
\arguments{
\item{y}{Numeric vector with "times" attribute}

\item{ylabel}{Character string for the y-axis label}

\item{text}{optional character string for margin text, e.g. for station name, 
location, or other notes.}
}
\value{
Returns a list containing results from the trend and changepoint
  analysis. This list has the following elements:
  \itemize{
    \item slope - Numeric vector containing the intercept and slope of the 
      prewhitened linear trend computed with \code{\link[zyp]{zyp.trend.vector}}
      using Yue Pilon's method
    \item ci1 - numeric vector containing the intercept and slope of the
      upper confidence bound. See \code{\link[zyp]{confint.zyp}}
    \item ci2 - numeric vector of length 2 containing the intercept and slope
      of the lower confidence bound. See \code{\link[zyp]{confint.zyp}}
    \item pval - numeric value indicatng the significance value of the detected
      trend, Kendall test computed within \code{\link[zyp]{zyp.trend.vector}}
    \item cpts - numeric vector of changepoints if any are found, computed 
      with \code{\link[changepoint]{cpt.meanvar}}
    \item means - numeric vector of means computed with 
      \code{\link[changepoint]{cpt.meanvar}}
  }
}
\description{
This function plots a time series of a streamflow metric with the prewhitened
linear trend and any detected changepoints in mean and variance.
}
\details{
This function plots detected changepoints as a vertical dashed line.
  The means on either side of a changepoint are plotted as solid black lines.
  If the temporal trend is significant (p-value < 0.1), the trend is plotted as 
  a blue or red line for an increasing or decreasing trend, respectively.
  The upper and lower 95% confidence bounds for the trend are represented by the
  dotted red or blue lines.  If a trend is not significant, it is not plotted.
}
\examples{
data(cania.sub.ts)

# calculate and plot the annual maximum series
res <- pk.max(cania.sub.ts)
res1 <- screen.metric(res, ylabel="Q (m3/s)", 
text="Caniapiscau River, Annual Maximum Series")

# calculate and plot the annual minimum series
res <- MAMn(cania.sub.ts, n=1)
res1 <- screen.metric(res, ylabel="Discharge (m3/s)", 
text="Caniapiscau River, Annual Minimum Series")
}
\seealso{
See \code{\link{screen.summary}} to create a summary screening plot of 
  high flow, low flow, or baseflow metrics.
  
  See \code{\link{metrics.all}} to calculate 30 different streamflow metrics at once.
  The \code{\link{screen.metric}} function could then be used to loop through the metrics and 
  create an individual plot for each.
}
\author{
Jennifer Dierauer
}
