% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/methods-distance.R
\docType{methods}
\name{distance}
\alias{distance}
\alias{distance,DiscontinuousFuzzyNumber,DiscontinuousFuzzyNumber-method}
\alias{distance,DiscontinuousFuzzyNumber,FuzzyNumber-method}
\alias{distance,FuzzyNumber,DiscontinuousFuzzyNumber-method}
\alias{distance,FuzzyNumber,FuzzyNumber-method}
\title{Calculate the Distance Between Two Fuzzy Numbers}
\usage{
\S4method{distance}{FuzzyNumber,FuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{FuzzyNumber,DiscontinuousFuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{DiscontinuousFuzzyNumber,FuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{DiscontinuousFuzzyNumber,DiscontinuousFuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)
}
\arguments{
\item{e1}{a fuzzy number}

\item{e2}{a fuzzy number}

\item{...}{additional arguments passed to \code{\link{integrate}}}

\item{type}{one of \code{"Euclidean"}, \code{"EuclideanSquared"}}
}
\value{
Returns the calculated distance, i.e. a single numeric value.
}
\description{
Currently, only Euclidean distance may be calculated.
We have \eqn{d_E^2(A,B) := \int_0^1  (A_L(\alpha)-B_L(\alpha))^2\,d\alpha,\int_0^1 + (A_U(\alpha)-B_U(\alpha))^2\,d\alpha
}{d_E^2(A,B) := int_0^1  (A_L(\alpha)-B_L(\alpha))^2 d\alpha + int_0^1  (A_U(\alpha)-B_U(\alpha))^2 d\alpha},
see (Grzegorzewski, 1988).
}
\details{
The calculation are done using numerical integration,
}
\references{
Grzegorzewski P., Metrics and orders in space of fuzzy numbers,
Fuzzy Sets and Systems 97, 1998, pp. 83-94.
}
\seealso{
Other DiscontinuousFuzzyNumber-method: \code{\link{DiscontinuousFuzzyNumber-class}};
  \code{\link{DiscontinuousFuzzyNumber}};
  \code{\link{integrateAlpha}},
  \code{\link{integrateAlpha,DiscontinuousFuzzyNumber,character,numeric,numeric-method}},
  \code{\link{integrateAlpha,FuzzyNumber,character,numeric,numeric-method}};
  \code{\link{plot}},
  \code{\link{plot,DiscontinuousFuzzyNumber,missing-method}},
  \code{\link{plot,FuzzyNumber,missing-method}},
  \code{\link{plot,PiecewiseLinearFuzzyNumber,missing-method}},
  \code{\link{plot,TrapezoidalFuzzyNumber,missing-method}}

Other FuzzyNumber-method: \code{\link{*,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{*,TrapezoidalFuzzyNumber,numeric-method}},
  \code{\link{*,numeric,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{+,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{+,numeric,FuzzyNumber-method}},
  \code{\link{-,FuzzyNumber,ANY-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{-,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{-,numeric,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{Arithmetic}};
  \code{\link{FuzzyNumber-class}};
  \code{\link{FuzzyNumber}}; \code{\link{alphaInterval}},
  \code{\link{alphaInterval,FuzzyNumber-method}},
  \code{\link{alphaInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{alphaInterval,PowerFuzzyNumber-method}},
  \code{\link{alphaInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{alphacut}},
  \code{\link{alphacut,FuzzyNumber,numeric-method}};
  \code{\link{ambiguity}},
  \code{\link{ambiguity,FuzzyNumber-method}};
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.FuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.FuzzyNumber,numeric-method}};
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,numeric-method}};
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,numeric-method}};
  \code{\link{as.character}},
  \code{\link{as.character,FuzzyNumber-method}},
  \code{\link{as.character,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.character,PowerFuzzyNumber-method}},
  \code{\link{as.character,TrapezoidalFuzzyNumber-method}};
  \code{\link{core}},
  \code{\link{core,FuzzyNumber-method}};
  \code{\link{evaluate}},
  \code{\link{evaluate,FuzzyNumber,numeric-method}};
  \code{\link{expectedInterval}},
  \code{\link{expectedInterval,FuzzyNumber-method}},
  \code{\link{expectedInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{expectedInterval,PowerFuzzyNumber-method}},
  \code{\link{expectedInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{expectedValue}},
  \code{\link{expectedValue,FuzzyNumber-method}};
  \code{\link{integrateAlpha}},
  \code{\link{integrateAlpha,DiscontinuousFuzzyNumber,character,numeric,numeric-method}},
  \code{\link{integrateAlpha,FuzzyNumber,character,numeric,numeric-method}};
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{piecewiseLinearApproximation,FuzzyNumber-method}};
  \code{\link{plot}},
  \code{\link{plot,DiscontinuousFuzzyNumber,missing-method}},
  \code{\link{plot,FuzzyNumber,missing-method}},
  \code{\link{plot,PiecewiseLinearFuzzyNumber,missing-method}},
  \code{\link{plot,TrapezoidalFuzzyNumber,missing-method}};
  \code{\link{show}},
  \code{\link{show,FuzzyNumber-method}};
  \code{\link{supp}},
  \code{\link{supp,FuzzyNumber-method}};
  \code{\link{trapezoidalApproximation}},
  \code{\link{trapezoidalApproximation,FuzzyNumber-method}};
  \code{\link{value}},
  \code{\link{value,FuzzyNumber-method}};
  \code{\link{weightedExpectedValue}},
  \code{\link{weightedExpectedValue,FuzzyNumber-method}};
  \code{\link{width}},
  \code{\link{width,FuzzyNumber-method}}
}

