% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_GAGA.R
\name{LM_GAGA}
\alias{LM_GAGA}
\title{Fit a linear model via the GAGA algorithm}
\usage{
LM_GAGA(
  X,
  y,
  alpha = 3,
  itrNum = 50,
  thresh = 0.001,
  QR_flag = FALSE,
  flag = TRUE,
  lamda_0 = 0.001,
  fix_sigma = FALSE,
  sigm2_0 = 1,
  fdiag = TRUE,
  frp = TRUE
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.}

\item{y}{Quantitative response vector.}

\item{alpha}{Hyperparameter. The suggested value for alpha is 2 or 3.
When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.}

\item{itrNum}{The number of iteration steps. In general, 20 steps are enough.
If the condition number of \code{X} is large, it is recommended to greatly increase the
number of iteration steps.}

\item{thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{QR_flag}{It identifies whether to use QR decomposition to speed up the algorithm.
Currently only valid for linear models.}

\item{flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{lamda_0}{The initial value of the regularization parameter for ridge regression.
The running result of the algorithm is not sensitive to this value.}

\item{fix_sigma}{It identifies whether to update the variance estimate of the Gaussian noise or not.
\code{fix_sigma=TRUE} uses the initial variance as the variance estimate in each loop.
\code{fix_sigma=FALSE} updates the variance estimate in each loop.}

\item{sigm2_0}{The initial variance of the Gaussian noise.}

\item{fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{frp}{Identifies whether pre-processing is performed by the OMP method to reduce the number of parameters}
}
\value{
Coefficient vector.
}
\description{
Fit a linear model with a Gaussian noise via the Global Adaptive Generative Adjustment algorithm
}
\examples{
# Gaussian
set.seed(2022)
p_size = 30
sample_size=300
R1 = 3
R2 = 2
ratio = 0.5 # The ratio of zeroes in coefficients
# Set the true coefficients
zeroNum = round(ratio*p_size)
ind = sample(1:p_size,zeroNum)
beta_true = runif(p_size,0,R2)
beta_true[ind] = 0
X = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
y=X\%*\%beta_true + rnorm(sample_size,mean=0,sd=2)
# Estimation
fit = GAGAs(X,y,alpha = 3,family="gaussian")
Eb = fit$beta
#Create testing data
X_t = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
y_t=X_t\%*\%beta_true + rnorm(sample_size,mean=0,sd=2)
#Prediction
Ey = predict.GAGA(fit,newx=X_t)

cat("\n err:", norm(Eb-beta_true,type="2")/norm(beta_true,type="2"))
cat("\n acc:", cal.w.acc(as.character(Eb!=0),as.character(beta_true!=0)))
cat("\n perr:", norm(Ey-y_t,type="2")/sqrt(sample_size))
}
