% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_multinomial_gaga}
\alias{cpp_multinomial_gaga}
\title{Fit a multinomial model via the GAGA algorithm using cpp}
\usage{
cpp_multinomial_gaga(
  X,
  y,
  s_alpha,
  s_itrNum,
  s_thresh,
  s_flag,
  s_lamda_0,
  s_fdiag,
  s_subItrNum
)
}
\arguments{
\item{X}{Input matrix, of dimension nobs*nvars; each row is an observation.
If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.}

\item{y}{a One-hot response matrix or a \code{nc>=2} level factor}

\item{s_alpha}{Hyperparameter. The suggested value for alpha is 1 or 2.
When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.}

\item{s_itrNum}{The number of iteration steps. In general, 20 steps are enough.
If the condition number of \code{X} is large, it is recommended to greatly increase the
number of iteration steps.}

\item{s_thresh}{Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.}

\item{s_flag}{It identifies whether to make model selection. The default is \code{TRUE}.}

\item{s_lamda_0}{The initial value of the regularization parameter for ridge regression.
The running result of the algorithm is not sensitive to this value.}

\item{s_fdiag}{It identifies whether to use diag Approximation to speed up the algorithm.}

\item{s_subItrNum}{Maximum number of steps for subprocess iterations.}
}
\value{
Coefficient matrix with K-1 columns beta_1,...,beta_{K-1} where K is the class number.
For k=1,..,K-1, the probability
\deqn{Pr(G=k|x)=exp(x^T beta_k) /(1+sum_{k=1}^{K-1}exp(x^T beta_k))}.
For k=K, the probability \deqn{Pr(G=K|x)=1/(1+sum_{k=1}^{K-1}exp(x^T beta_k))}.
}
\description{
Fit a multinomial model the Global Adaptive Generative Adjustment algorithm
}
