% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.GAGA.R
\name{summary.GAGA}
\alias{summary.GAGA}
\title{Print a summary of GAGA object}
\usage{
\method{summary}{GAGA}(object, ...)
}
\arguments{
\item{object}{Fitted "GAGA" object.}

\item{...}{some other params}
}
\description{
Print a summary of GAGA object
}
\examples{
set.seed(2022)
p_size = 30
sample_size=300
R1 = 3
R2 = 2
ratio = 0.5 #The ratio of zeroes in coefficients
# Set the true coefficients
zeroNum = round(ratio*p_size)
ind = sample(1:p_size,zeroNum)
beta_true = runif(p_size,0,R2)
beta_true[ind] = 0
X = R1*matrix(rnorm(sample_size * p_size), ncol = p_size)
y=X\%*\%beta_true + rnorm(sample_size,mean=0,sd=2)
# Estimation
fit = GAGAs(X,y,alpha = 3,family="gaussian")
summary(fit)

}
