% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBJ_pvalue.R
\name{GBJ_pvalue}
\alias{GBJ_pvalue}
\title{GBJ_pvalue.R}
\usage{
GBJ_pvalue(observed_gbj, d, pairwise_cors, times_to_try = 5)
}
\arguments{
\item{observed_gbj}{The observed value of the GBJ statistic.}

\item{d}{The number of test statistics in the set.}

\item{pairwise_cors}{A vector of all d(d-1)/2 pairwise correlations between the test
statistics, where d is total number of test statistics in the set.}

\item{times_to_try}{Sometimes the numerical root-finder is finnicky, so we have to give
it extra chances to try and calculate the p-value if first time is failure.  Recommend
setting this parameter to 5.}
}
\value{
The p-value of the GBJ test.
}
\description{
Calculate the p-value for the Generalized Berk-Jones (GBJ) statistic.
}
\examples{
GBJ_pvalue(observed_gbj=2, d=5, pairwise_cors=rep(0.2,10))
}
