% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_functions.R
\name{vcov_local_comp}
\alias{vcov_local_comp}
\title{Get the variance estimates of the local component}
\usage{
vcov_local_comp(object, i, j, t)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{i}{An integer indicating the \eqn{i}-th block.}

\item{j}{An integer indicating the \eqn{j}-th individual in the \eqn{i}-th block.}

\item{t}{An integer indicating the time.}
}
\value{
The variance of the local component.
}
\description{
This function generates the variance estimates of the
local component for the \eqn{j}-th individual in block \eqn{i} at time \eqn{t}.
}
\examples{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
vcov_local_comp_ijt <- vcov_local_comp(est_multi, i = 1, j = 1, t = 1)
}
