% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCalignR.R
\docType{package}
\name{GCalignR}
\alias{GCalignR}
\alias{GCalignR-package}
\title{GCalignR: A package to align gas-chromatography peaks based on retention times}
\description{
\code{GCalignR} contains the following functions that are explained in the \href{../doc/GCalignR_step_by_step.html}{Vignette}:

\link{align_chromatograms}

\link{check_input}

\link{gc_heatmap}

\link{norm_peaks}
}
\details{
Gas-chromatography (GC) & gas-chromatography-mass-spectrometry (GC-MS) are
powerful analytical separation techniques that can be used for diverse
applications. Even though gas-chromatography is highly sensitive and retention
times are substance-specific (in equal settings), small systematic shifts in
chromatograms as well as unavoidable inaccuracies in peak detection make it difficult
to compare chromatograms and analyse patterns across samples. GCalignR provides functions
to align chromatography peaks across samples based on retention times and simple means of evaluating the
quality of the alignment.
}

