% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GCalign.R
\name{plot.GCalign}
\alias{plot.GCalign}
\title{Plot Diagonstics for an Gcalign Object}
\usage{
\method{plot}{GCalign}(x, which_plot = c("all", "shifts", "variation",
  "peak_numbers", "peaks_shared"), ...)
}
\arguments{
\item{x}{Object of class GCalign, created by \code{\link{align_chromatograms}}}

\item{which_plot}{character string indicating which plot is returned. Available are
\strong{"shifts"} a histogram of linear adjustments undertaken in aligning chromatograms,
\strong{"variation"} a histogram summarising the range of retention times for every peak defined
by the difference between minimum and maximum retention times respectively. The third option
is \strong{"peak_numbers"} plotting a barchart of the number of sharings per sample. Additionally \strong{"peaks_shared"} produces a histogram of the proportion with which sharings are shared among samples. This means for every sharing the proportion of samples containing the respective peak is estimated. By default all plots are returned as subplots of one figure.}

\item{...}{optional arguments passed on to methods. See
\code{\link[graphics]{plot}}, \code{\link[graphics]{hist}} and \code{\link[graphics]{barplot}}.
Note that optional arguments are not passed on when plotting all figures.}
}
\value{
Depending on the value of \code{which_plot} a data frame containing the data source of the respective plot is returned. If \code{which_plot = "all"} no output is returned.
}
\description{
Four plots are currently available: One plot visualises the distribution of linear shifts
that were applied in order to align chromatograms to a reference before aligning individual peaks.
A second plot illustrates the remaining variation of retention times on the level of individual
peaks by plotting the distribution of retention time ranges. The third plots shows a distribution
of peak numbers after aligning the chromatograms. A fourth plot illustrates the amount of peak sharing among chromatograms in a histogram.
}
\examples{
## GCalign object
data("aligned_peak_data")

## All plots are shown by default
plot(aligned_peak_data)

## Distribution of peak numbers
plot(aligned_peak_data, which_plot = "peak_numbers")

## variation of retention times
plot(aligned_peak_data, which_plot = "variation")

}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) & Meinolf Ottensmann
 (meinolf.ottensmann@web.de)
}

