% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyGENEA.R
\name{classifyGENEA}
\alias{classifyGENEA}
\title{Classify Data into Categories defined in an rpart GENEA fit}
\usage{
classifyGENEA(testfile, trainingfit = trainingFit, newdata,
  outputname = "_classified", outputdir = "GENEAclassification",
  verbose = TRUE, allprobs = FALSE, setinf = 100, datacols = "default",
  samplefreq = 100, stepmethod = c("Chebyfilter", "Butterfilter", "longrun",
  "none"), changepoint = c("UpDownDegrees", "TempFreq", "UpDownFreq"),
  smlen = 20L, filterorder = 4L, threshold = 0.001, boundaries = c(0.15,
  1), Rp = 0.5, plot.it = FALSE, plot.seg = FALSE,
  plot.seg.outputfile = "Changepoint", Centre = TRUE, STFT = FALSE,
  win = 10, penalty = "Manual", pen.value = 10, intervalseconds = 30,
  mininterval = 5, ...)
}
\arguments{
\item{testfile}{character string stating path to a GENEActiv bin file, or a folder 
containing GENEActiv bin files.}

\item{trainingfit}{a GENEA rpart object created by \code{\link{createGENEAmodel}} 
that gives the decision tree that was fitted from the training data. 
These are the parameters used to predict the new data.}

\item{newdata}{a new data frame that is to be classified (provide instead of testfile). 
The data must contain the \code{\link{features}} named in the trainingfit.}

\item{outputname}{file name root (excluding extension) for saving the 
classification output (default "classified").}

\item{outputdir}{absolute or relative path to directory in which artifacts 
(plot and changes files) should be created or \code{NULL} 
(default "GENEAclassification").}

\item{verbose}{single logical should additional progress reporting be 
printed at the console (default \code{TRUE}).}

\item{allprobs}{single logical should all estimated probabilities be 
reported rather than probability of selected class (default \code{FALSE}).}

\item{setinf}{single numeric an arbitrary value to replace Inf in calculated 
columns or NA to ignore Inf values. (default 100).
-setinf is used to replace -Inf. Alternatively, use setinf NULL to leave Inf as is.}

\item{datacols}{a vector constructed 'column.summary' or 'default'. See \code{\link{segmentation}} for details.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number. (default 100)}

\item{stepmethod}{defines the method used by the step counting algoirthm, see \code{\link[GENEAclassify]{stepCounter}} for details.}

\item{changepoint}{defines the change point analysis to use. UpDownDegrees performs the change point analysis on the variance of arm elevation and wrist rotation. TempFreq performs a change point on the variance in the temeprature and Frequency (Typically better for sleep behaviours)}

\item{smlen}{defines the window length used within the step counting alogirthm.}

\item{filterorder}{The order of the filter applied with respect to the butter of cheby options.}

\item{threshold}{Threshold for the step counter to register a step.}

\item{boundaries}{to passed to the filter in the step counting algorithm.}

\item{Rp}{the decibel level that the cheby filter takes. see \code{\link[signal]{cheby1}}}

\item{plot.it}{(logical) Creates a plot showing the zero crossings counted by the step counting algorithm#' @param Centre Centres the xz signal about 0 when set to True.}

\item{plot.seg}{(logical) Creates a plot displaying the changepoint locations}

\item{plot.seg.outputfile}{The name of the png file created that shows the change points on a positionals plots.}

\item{Centre}{Centres the xz signal about 0 when set to True.}

\item{STFT}{If STFT is TRUE then the Step Counter uses the STFT function to find the length of the window for each segment.}

\item{win}{The window length at which to compute the STFT for the changepoint analysis. See \code{\link[GENEAread]{stft}}}

\item{penalty}{single characgter, the penalty to use for changepoint detection. default ("SIC")}

\item{pen.value}{Value of the type 1 error required when penalty is "Asymptotic"}

\item{intervalseconds}{An integer number of seconds between 5 and 30 during which at most one changepoint may occur.}

\item{mininterval}{single numeric that defines the smallest changepoint initially found. Passed to \code{\link[changepoint]{cpt.var}} as the variable minseglen}

\item{...}{other arguments to be passed to \code{\link{dataImport}}, 
\code{\link{segmentation}} and other functions}
}
\value{
The function will return the data frame that was provided as newdata with 
additional columns. \enumerate{
    \item \code{Class}, a factor indicating that the predicted category of the segment
    \item \code{p.Class}, estimated probability that the prediction is correct
}
Alternatively, by setting argument allprobs to TRUE, a column constructed 
'p.level' containing the estimated probability of each possible class 
will be returned instead.
}
\description{
Perform classification on segmented GENEActiv bin data using an 
rpart GENEA training fit.
}
\details{
This function will apply the rules determined by the rpart GENEA 
decision tree passed to argument trainingfit to the columns 
of newdata to classify into classes 
(view using \code{"\link[=levels.GENEA]{levels}"}).
}
\examples{
## segData <- read.csv(system.file(package = "GENEAclassify", 
##       "data", "trainingData9.csv"))
## The training fit can be created by provided the file path to the training data
## in the function getTrainingData - see the help file for more details
## Uses the fitted decision tree to predict the segmented data
## class9 <- classifyGENEA(newdata = segData, outputname = NULL)
## head(class9)
## table(class9$Class)
}
