% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotSegmentProjection}
\alias{plotSegmentProjection}
\title{Plot a projection representation}
\usage{
plotSegmentProjection(segmentationCSV, plotRows, projection = "aitoff",
  col = "red", singlePlot = TRUE, nsims = 1000)
}
\arguments{
\item{segmentationCSV}{The file path to the csv file created from the segmentation process containing all features.}

\item{plotRows}{The rows from the csv file to be used to simulate plotting data.}

\item{projection}{The type of projection to be used. Can be any of those used by \code{mapproject} in the package \code{mapproj}.}

\item{col}{A character string to indicate the colour of the heat mapping.}

\item{singlePlot}{(logical) Indicates wether all rows should be added to one plot.}

\item{nsims}{The number of simulated values to plot. (Default = 1000 however, if your computer has little RAM reduce this)
 @details This function takes the features from the segmentation procedure and uses them to simulate data for
elevation and rotation. This data is then plotted on a projected representation of the sphere.
Required columns are:\enumerate{
    \item UpDown.median
    \item UpDown.mad
    \item Degrees.median
    \item Degrees.mad
}}
}
\value{
There is no return to the console. As a side effect a graphic is created.
}
\description{
Create a projection representation of the spherical data
}
\examples{
\dontrun{
segmentationCSV = system.file("data", "SegData.csv", package = "GENEAsphere")
plotRows = c(1:1)
plotSegmentProjection(segmentationCSV, plotRows, projection = "aitoff", 
                    col = "red", singlePlot = TRUE, nsims = 1000)}
}
