% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.global_envelope2d}
\alias{plot.global_envelope2d}
\title{Plotting function for 2d global envelopes}
\usage{
\method{plot}{global_envelope2d}(
  x,
  fixedscales = TRUE,
  main,
  what = c("obs", "hi", "lo", "hi.sign", "lo.sign"),
  sign.col = "red",
  transparency = 85/255,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A 'global_envelope' object for two-dimensional functions}

\item{fixedscales}{Logical. TRUE for the same scales for all images.}

\item{main}{The overall main.}

\item{what}{Character vector specifying what information should be plotted for 2d functions.
A combination of:
Observed (\code{"obs"}), upper envelope (\code{"hi"}), lower envelope (\code{"lo"}),
observed with significantly higher values highlighted (\code{"hi.sign"}),
observed with significantly lower values highlighted (\code{"lo.sign"}).}

\item{sign.col}{The color for the significant regions. Default to "red".}

\item{transparency}{A number between 0 and 1 (default 85/255, 33% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions for 2d
functions.}

\item{digits}{The number of digits used for printing the p-value or p-interval in the main,
if using the default main.}

\item{...}{Ignored.}
}
\description{
Plotting function for 2d global envelopes
}
