% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclustering.r
\name{plot.fclust}
\alias{plot.fclust}
\title{Plot method for the class 'fclust'}
\usage{
\method{plot}{fclust}(x, plotstyle = c("marginal", "joined"), coverage = 0.5, nstep, ncol, ...)
}
\arguments{
\item{x}{An 'fclust' object.}

\item{plotstyle}{The resulting central regions of clusters can be plotted by sorting the
appropriate \code{curve_set} only 'marginal' or by sorting the joined list of \code{curve_set}
objects 'joined'. If 'joined' is used the shown central regions corresponds to the joined
ordering used to cluster the functional data. If 'marginal' is used the shown central regions
do not correspond to the joined ordering used to cluster the functional data, but better express
the shape of cluster with respect to given \code{curve_set}.}

\item{coverage}{The coverage of central regions to be used to show the clusters.}

\item{nstep}{1 or 2 for how to contruct a combined (joined) global envelope
if there are more than one sets of curves. Default to 1, if the numbers of points
where the curves are observed (r) are the same in each set, and 2 otherwise.}

\item{ncol}{The number of columns in the graphical output, when there is just one set of curves
that has been ordered. If not given, \code{c(1, k+1)} is used, which gives all plots in one row.
For more sets of curves, the rows are fixed to correspond to the sets (one row for each set).}

\item{...}{Ignored.}
}
\description{
Plot method for the 'fclust' objects returned by \code{\link{fclustering}}.
}
\details{
The clusters are shown respectively for each \code{curve_set}. Thus for each \code{curve_set}
the panel with all the medoids is shown followed by all clusters represented by central region,
medoid and all curves belonging to it.

For all sources, the function plots the deepest curves for all clusters and
the deepest curve of each cluster together with the desired central region and
all the curves of the group.
}
\references{
Dai, W., Athanasiadis, S., Mrkvička, T. (2021) A new functional clustering method with combined dissimilarity sources and graphical interpretation. Intech open, London, UK. DOI: 10.5772/intechopen.100124
}
