% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes.r
\name{qdir_envelope}
\alias{qdir_envelope}
\alias{st_envelope}
\alias{unscaled_envelope}
\title{Global scaled maximum absolute difference (MAD) envelope tests}
\usage{
qdir_envelope(curve_set, ...)

st_envelope(curve_set, ...)

unscaled_envelope(curve_set, ...)
}
\arguments{
\item{curve_set}{A \code{\link{curve_set}} object, or an \code{envelope} object of
\pkg{spatstat}. If an envelope object is given, it must contain the summary
functions from the simulated patterns which can be achieved by setting
savefuns = TRUE when calling the function of \pkg{spatstat}.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.}
}
\value{
An object of class \code{global_envelope} of \code{combined_global_envelope}
which can be printed and plotted directly. See \code{\link{global_envelope_test}} for more details.
}
\description{
Performs the global scaled MAD envelope tests, either directional quantile or studentised,
or the unscaled MAD envelope test. These tests correspond to calling the
function \code{\link{global_envelope_test}} with \code{type="qdir"}, \code{type = "st"} and
\code{type="unscaled"}, respectively. The functions \code{qdir_envelope}, \code{st_envelope} and
\code{unscaled_envelope} have been kept for historical reasons;
preferably use \code{\link{global_envelope_test}} with the suitable \code{type} argument.
}
\details{
The directional quantile envelope test (Myllymäki et al., 2015, 2017)
takes into account the unequal variances of the test function T(r)
for different distances r and is also protected against asymmetry of T(r).

The studentised envelope test (Myllymäki et al., 2015, 2017)
takes into account the unequal variances of the test function T(r)
for different distances r.

The unscaled envelope test (Ripley, 1981) corresponds to the classical maximum
deviation test without scaling, and leads to envelopes with constant width over the distances r.
Thus, it suffers from unequal variance of T(r) over the distances r and from the asymmetry of
distribution of T(r). We recommend to use the other global envelope tests available,
see \code{\link{global_envelope_test}} for full list of alternatives.
}
\examples{
# See more examples in ?global_envelope_test
## Testing complete spatial randomness (CSR)
#-------------------------------------------
if(require("spatstat.explore", quietly=TRUE)) {
  X <- spruces
  \donttest{nsim <- 999 # Number of simulations}
  \dontshow{nsim <- 19 # Number of simulations for testing}
  ## Test for complete spatial randomness (CSR)
  # Generate nsim simulations under CSR, calculate centred L-function for the data and simulations
  env <- envelope(X, fun="Lest", nsim=nsim, savefuns=TRUE,
                  correction="translate", transform=expression(.-r),
                  simulate=expression(runifpoint(ex=X)))
  res_qdir <- qdir_envelope(env) # The directional quantile envelope test
  plot(res_qdir)

  ## Advanced use:
  # Create a curve set, choosing the interval of distances [r_min, r_max]
  curve_set <- crop_curves(env, r_min=1, r_max=8)
  # The directional quantile envelope test
  res_qdir <- qdir_envelope(curve_set); plot(res_qdir)
  # The studentised envelope test
  res_st <- st_envelope(curve_set); plot(res_st)
  # The unscaled envelope test
  res_unscaled <- unscaled_envelope(curve_set); plot(res_unscaled)
}
}
\references{
Myllymäki, M., Grabarnik, P., Seijo, H. and Stoyan. D. (2015). Deviation test construction and power comparison for marked spatial point patterns. Spatial Statistics 11: 19-34. doi: 10.1016/j.spasta.2014.11.004

Myllymäki, M., Mrkvička, T., Grabarnik, P., Seijo, H. and Hahn, U. (2017). Global envelope tests for spatial point patterns. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 79: 381–404. doi: 10.1111/rssb.12172

Ripley, B.D. (1981). Spatial statistics. Wiley, New Jersey.
}
\seealso{
\code{\link{global_envelope_test}}
}
