% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_test_moment_calcs_old.R
\name{GE_test_moment_calcs_old}
\alias{GE_test_moment_calcs_old}
\title{GE_test_moment_calcs_old.R}
\usage{
GE_test_moment_calcs_old(beta_list, rho_list, prob_G, cov_Z = NULL,
  cov_W = NULL, num_sub = 2e+06, test_threshold = 0.003)
}
\arguments{
\item{rho_list}{A list of the 6 pairwise covariances between the
covariates.  These should be in the order (1) cov_GE (2) cov_GZ (3) cov_EZ
(4) cov_GW (5) cov_EW (6) cov_ZW.  If Z and/or W include multiple covariates, then
terms like cov_GZ should be a vector.  
If Z and/or M/W do not exist in your model, then treat them as constants 0. For example,
if Z doesn't exist and W includes 2 covariates, then set cov(EZ) = 0 and cov(ZW) = (0,0).}

\item{prob_G}{Probability that each allele is equal to 1.  Since each SNP has
two alleles, the expectation of G is 2*prob_G.}

\item{cov_Z}{Only used if Z is a vector, gives the covariance matrix of Z (remember by assumption
Z has mean 0 and variance 1).  The (i,j) element of the matrix should be the (i-1)(i-2)/2+j element
of the vector. If Z or M are vectors, then cov_ZW should be a vector in the order
(cov(Z_1,W_1),cov(Z_1,W_2),...,cov(Z_1,W_q),cov(Z_2,W_1),........,cov(Z_p,W_q) where Z is 
a vector of length p and W is a vector of length q.}

\item{cov_W}{Only used if W is a vector, gives the covariance matrix of W (remember by assumption
W has mean 0 and variance 1).  The (i,j) element of the matrix should be the (i-1)(i-2)/2+j element
of the vector.}

\item{test_threshold}{How much margin for error on tests?}

\item{num_sum}{Number of subjects to do the simulation with.}
}
\value{
Nothing
}
\description{
Test function mostly for internal use to ensure the higher order moments (covariances)
calculated in GE_bias_normal_squaredmis_old() are correct. Will give warning messages if
some calculations appear to be incorrect.  If receive warning messages, run again, and
if still receive the same warning messages, something may be wrong.
}
\examples{
GE_test_moment_calcs_old(beta_list=as.list(runif(n=6, min=0, max=1)), 
		rho_list=as.list(rep(0.3,6)), prob_G=0.3)
}
\keyword{internal}

