% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medsanova.R
\name{medsanova}
\alias{medsanova}
\title{medSANOVA: Median survival analyis-of-variance}
\usage{
medsanova(
  formula,
  event = "event",
  data = NULL,
  nperm = 1999,
  var_method = "twosided",
  var_level = 0.9,
  nested.levels.unique = FALSE
)
}
\arguments{
\item{formula}{A model \code{formula} object. The left hand side contains the time variable and the right
hand side contains the factor variables of interest. An interaction term must be
specified.}

\item{event}{The name of the censoring status indicator with values 0=censored and
1=uncensored.
The default choice is "event"}

\item{data}{A data.frame, list or environment containing the variables in formula
and the censoring status
indicator. Default option is \code{NULL}.}

\item{nperm}{The number of permutations used for calculating the permuted p-value.
The default option is 1999.}

\item{var_method}{Method for the variance estimation of the sample medians. The default
is the "one-sided" confidence interval approach. Additionally, the "two-sided" confidence
interval approach can be used.}

\item{var_level}{A number between 0 and 1 specifying the confidence level for the
variance estimation method; the default value is 0.9.}

\item{nested.levels.unique}{A logical specifying whether the levels of the nested
factor(s) are labeled uniquely or not.
 Default is FALSE, i.e., the levels of the nested factor are the same for each
 level of the main factor.}
}
\value{
An  \code{medsanova} object containing the following components:
 \item{pvalues_stat}{The p-values obtained by \eqn{\chi^2}-approximation}
 \item{pvalues_per}{The p-values of the permutation approach}
 \item{statistics}{The value of the Wald-type test statistic along with the
 degrees of freedom of the \eqn{\chi^2}-distribution and the
 respective p-value, as well as the p-value of the
  permutation procedure.}
 \item{nperm}{The number of permutations used for calculating the permuted p-value.}
}
\description{
The function \code{medsanova} calculates the Wald-type test statistic for
inferring median survival differences in general factorial designs.
Respective p-values are obtain by a \eqn{\chi^2}-approximation and a permutation approach.
}
\details{
The \code{medsanova} function calculates the Wald-type statistic for median differences
in general factorial survival designs. Crossed as well as hierachically nested designs are
implemented. To estimate the sample medians' variances, a one-sided (resp. two-sided) confidence
interval approach is used and the level of this confidence interval can be specified by \code{var_level}.

  The \code{medsanova} function returns the test statistic as well as two
  corresponding p-values: the first is based on a \eqn{\chi^2} approximation and
  the second one is based on a permutation procedure.
}
\examples{
\donttest{
library("survival")
data(veteran)
out <- medsanova(formula ="time ~ trt*celltype",event = "status",
 data = veteran)

## Detailed informations:
summary(out)
}
}
\references{
Ditzhaus, M., Dobler, D. and Pauly, M.(2020). Inferring median survival
 differences in general factorial designs via permutation tests.
 Statistical Methods in Medical Research. doi:10.1177/0962280220980784.
}
