% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotTCC}
\alias{plotTCC}
\title{Plot test characteristic curve (TCC)}
\usage{
plotTCC(IP, Th)
}
\arguments{
\item{IP}{Object of class \code{GGUM}.}

\item{Th}{Theta estimates from function \code{Theta.EAP()}.}
}
\value{
The function returns a list with three elements: \item{coords}{(x, y)
  coordinates of the TCC.} \item{cor.OBS.EXP}{Correlation between observed
  and expected test scores (missing values pairwise removed).} 
  \item{cor.OBS.EXP.means}{Correlation between observed and expected mean
  test scores (missing values pairwise removed). The \eqn{\theta}{theta}
  interval between \eqn{-4}{-4} through \eqn{+4}{+4} is divided in 100
  subintervals of equal length. The observed and expected mean scores are
  computed for each subinterval.}
}
\description{
\code{plot.TCC} plots the TCC for the GUM and the GGUM.
}
\section{Details}{
 This function plots the test characteristic curve (TCC).
}

\examples{
\dontrun{
# For GUM:
# Generate data
#   (toy example: Too few items (due to computation time constraints) for 
#   accurate estimation of person parameters; larger number of items is 
#   required in practice):
gen1 <- GenData.GGUM(400, 5, 3, "GUM", seed = 139)
# Fit the GUM:
fit1 <- GUM(gen1$data, 3)
th1  <- Theta.EAP(fit1)
# Plot TCC:
plotTCC(fit1, th1)
}
\dontrun{
# For GGUM:
# Generate data:
set.seed(1); C <- sample(3:5, 10, replace = TRUE)
gen2 <- GenData.GGUM(2000, 10, C, "GGUM", seed = 156)
# Fit the GGUM:
fit2 <- GGUM(gen2$data, C)
th2  <- Theta.EAP(fit2)
# Plot TCC:
plotTCC(fit2, th2)
}

}
\author{
Jorge N. Tendeiro, \email{tendeiro@hiroshima-u.ac.jp}
}
