#' Programme for International Student Assessment (PISA) 2012 Data for Australia
#'
#' About PISA
#'
#' The Programme for International Student Assessment (PISA) is a triennial international survey which aims to evaluate education systems worldwide by testing the skills and knowledge of 15-year-old students. To date, students representing more than 70 economies have participated in the assessment.
#'
#' While 65 economies took part in the 2012 study, this data set only contains information from the country of Australia.
#'
#' @details \itemize{
#'   \item gender     : Factor w/ 2 levels "female","male": 1 1 2 2 2 1 1 1 2 1 ...
#'   \item age        : Factor w/ 4 levels "4","5","6","7": 2 2 2 4 3 1 2 2 2 2 ...
#'   \item homework   : num  5 5 9 3 2 3 4 3 5 1 ...
#'   \item desk       : num  1 0 1 1 1 1 1 1 1 1 ...
#'   \item room       : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item study      : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item computer   : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item software   : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item internet   : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item literature : num  0 0 1 0 1 1 1 1 1 0 ...
#'   \item poetry     : num  0 0 1 0 1 1 0 1 1 1 ...
#'   \item art        : num  1 0 1 0 1 1 0 1 1 1 ...
#'   \item textbook   : num  1 1 1 1 1 0 1 1 1 1 ...
#'   \item dictionary : num  1 1 1 1 1 1 1 1 1 1 ...
#'   \item dishwasher : num  1 1 1 1 0 1 1 1 1 1 ...
#'   \item PV1MATH    : num  562 565 602 520 613 ...
#'   \item PV2MATH    : num  569 557 594 507 567 ...
#'   \item PV3MATH    : num  555 553 552 501 585 ...
#'   \item PV4MATH    : num  579 538 526 521 596 ...
#'   \item PV5MATH    : num  548 573 619 547 603 ...
#'   \item PV1READ    : num  582 617 650 554 605 ...
#'   \item PV2READ    : num  571 572 608 560 557 ...
#'   \item PV3READ    : num  602 560 594 517 627 ...
#'   \item PV4READ    : num  572 564 575 564 597 ...
#'   \item PV5READ    : num  585 565 620 572 598 ...
#'   \item PV1SCIE    : num  583 627 668 574 639 ...
#'   \item PV2SCIE    : num  579 600 665 612 635 ...
#'   \item PV3SCIE    : num  593 574 620 571 666 ...
#'   \item PV4SCIE    : num  567 582 592 598 700 ...
#'   \item PV5SCIE    : num  587 625 656 662 670 ...
#'   \item SENWGT_STU : num  0.133 0.133 0.141 0.141 0.141 ...
#'   \item possessions: num  10 8 12 9 11 11 10 12 12 11 ...
#' }
#'
#' @docType data
#' @keywords datasets
#' @name australia_PISA2012
#' @usage data(australia_PISA2012)
#' @format A data frame with 8247 rows and 32 variables
#' @source \url{http://www.oecd.org/pisa/pisaproducts/database-cbapisa2012.htm}
NULL
