% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_env_meta_raster.R
\name{GIFT_env_meta_raster}
\alias{GIFT_env_meta_raster}
\title{Metadata for the environmental rasters in GIFT}
\usage{
GIFT_env_meta_raster(
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 10 columns.
}
\description{
Retrieve the metadata of every environmental raster accessible in GIFT.
}
\details{
Here is what each column refers to:

\emph{dataset} - Name of the source dataset\cr
\emph{layer_name} - Name of the environmental layer\cr
\emph{layer} - Full name\cr
\emph{description} - Description\cr
\emph{unit} - Unit\cr
\emph{coord_system} - Coordinate system\cr
\emph{resolution} - Resolution\cr
\emph{extent} - Extent\cr
\emph{version} - Version of the source\cr
\emph{ref_long} - Full reference to cite when using an environmental layer
}
\examples{
\donttest{
ex <- GIFT_env_meta_raster()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_env]{GIFT_env()}}
}
