% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_references.R
\name{GIFT_references}
\alias{GIFT_references}
\title{Metadata for references available in GIFT}
\usage{
GIFT_references(
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 14 columns.
}
\description{
Retrieve the metadata of every reference accessible in GIFT.
}
\details{
Here is what each column refers to:

\emph{ref_ID} - Identification number of the reference\cr
\emph{ref_long} - Full reference for the reference\cr
\emph{geo_entity_ref} - Name of the location\cr
\emph{type} - What type the source is\cr
\emph{subset} - What information regarding the status of species is
available\cr
\emph{taxon_ID} - Identification number of the group of taxa available\cr
\emph{taxon_name} - Name of the group of taxa available\cr
\emph{checklist} - Is the source a checklist\cr
\emph{native_indicated} - Whether native status of species is available in
the source\cr
\emph{natural_indicated} - Whether naturalized status of species is
available in the source\cr
\emph{end_ref} - Whether endemism information is available in the source\cr
\emph{traits} - Whether trait information is available in the source\cr
\emph{restricted} - Whether the access to this reference is restricted\cr
\emph{proc_date} - When the source was processed
}
\examples{
\donttest{
ex <- GIFT_references()
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
